//usbstuff.c 

//za direktno includanje

//pred tem mora biti includan userdata.h

//25 sep 2020	dodal timeout parameter v fill_transfers

//---------------------------------------------------------
//interf: kateri interface na cipu
//		FT2232 ima dva, FT4232 ima stiri [0...3]
//		interface 0: endpointa in=2 out=81
//		interface 1: endpointa in=4 out=83
//		interface 2: endpointa in=6 out=85
//		interface 3: endpointa in=8 out=87
int ft2232_get_handle(libusb_device_handle **handle, libusb_context **context, int intrf)
{
int i;
int er[16];
size_t cnt,ii;
int interface;
libusb_device **list;
libusb_device *found = NULL;
libusb_device *device;
struct libusb_device_descriptor desc;

  
for (i=0;i<16;i++) er[i]=0;
er[1]=libusb_init(context);
libusb_set_debug(*context,3);	// 0...3

cnt = libusb_get_device_list(*context, &list);
ii = 0;
if (cnt < 0)
    {
    perror("Libusb get device list");
    return -1;
    }
for (ii = 0; ii < cnt; ii++)
  {
  device = list[ii];
  er[2]=libusb_get_device_descriptor(device, &desc);
  if ((desc.idVendor==0x0403)&&(desc.idProduct==0x6010))
    {
    printf("Found a FT2232\n");
    found = device;
    break;
    }
  }
if (found)
  {
  er[3] = libusb_open(found, handle);
  if (er[3])
	{
        perror("Libusb open");
	libusb_free_device_list(list,1);
	return -1;
	}
  }
else
  {
  printf("No FT2232 found\n");
  return -1;
  }
  
libusb_free_device_list(list,1);

for (interface = 0; interface < 2; interface++)
  {
  if (libusb_kernel_driver_active(*handle, interface) == 1)
    {
    if ((er[4] = libusb_detach_kernel_driver(*handle, interface)))
      {
      perror("Error detaching kernel driver");
      return er[4];
      }
    }
  }
/*
if ((er[5] = libusb_set_configuration(*handle, 1)))
  {
  perror("Error setting configuration");
  return er[5];
  }
*/

er[7]=libusb_claim_interface (*handle, intrf); if (er[7]) perror("claim");

return 0;
}

//-------------------------------------------------------------
int fill_transfers(libusb_device_handle *handle, void *callback, buffers buff, cbdata *ud, struct libusb_transfer **trans, int timeout)
{
int nt=MAXTRANS;	//number of simultaneous transfers, max MAXTRANS
int chunk;
int endpoint=1;
//int timeout=10000;
int i;

//PREPARE (FILL) USB TRANSFER STRUCTURES
printf("Filling USB transfer structures...\n");
chunk=CHUNKSIZE;
for (i=0;i<nt;i++)
  {
  trans[i]=libusb_alloc_transfer(0);
  if (trans[i]==NULL)
    {
    printf("\nSampler: Could not allocate transfer\n");
    return -1;
    }
  libusb_fill_bulk_transfer(trans[i], handle, endpoint+0x80, buff[i], chunk, (libusb_transfer_cb_fn)callback, &ud[i], timeout);
//  trans[i]->flags=LIBUSB_TRANSFER_SHORT_NOT_OK;
  }
return 0;
}

//------------------------------------------------------
int set_priority()
{
int er[2];
struct sched_param pp;
  
er[0]=mlockall(MCL_CURRENT);
if (er[0]!=0) perror("Mlockall");
pp.sched_priority=55;
er[1]=sched_setscheduler(0,SCHED_FIFO,&pp);
//er[0]=sched_setscheduler(0,SCHED_RR,&pp);
if (er[1]!=0) perror("Sched_setscheduler");
return 0;  
}

//---------------------------------------------------
//set FT2232 sync FIFO mode
int ft2232_set_syncfifo(libusb_device_handle *handle)
{
int er;
//handle, request type, request, value, index, data, length, timeout
// 0B = set bitmode  0000 = mode<<8 | direction (reset = 00)
er=libusb_control_transfer(handle, 0x40, 0x0B, 0x0000, 0x01, NULL, 0, 5000);
//handle, request type, request, value, index, data, length, timeout
// 0B = set bitmode  4000 = mode<<8 | direction (sync fifo mode = 40)
er=libusb_control_transfer(handle, 0x40, 0x0B, 0x4000, 0x01, NULL, 0, 5000);
if (er) perror("set bitmode");
return 0;
}

//---------------------------------------------------
//set FT2232 sync bitbang mode
//interf: kateri interface na cipu
//		FT2232 ima dva, FT4232 ima stiri [1...4]
int ft2232_set_bitbang_s(libusb_device_handle *handle, int intrf, int dir)
{
int er,v;
//handle, request type, request, value, index, data, length, timeout
// 0B = set bitmode  0000 = mode<<8 | direction (reset = 00)
er=libusb_control_transfer(handle, 0x40, 0x0B, 0x0000, 0x01, NULL, 0, 5000);
//handle, request type, request, value, index, data, length, timeout
// 0B = set bitmode  4000 = mode<<8 | direction (sync bitbang = 04)
v=0x0400+dir;
er=libusb_control_transfer(handle, 0x40, 0x0B, v, intrf, NULL, 0, 5000);
if (er) perror("set bitmode");
return 0;
}

//---------------------------------------------------
//set FT2232 async bitbang mode
//interf: kateri interface na cipu
//		FT2232 ima dva, FT4232 ima stiri [1...4]
int ft2232_set_bitbang_a(libusb_device_handle *handle, int intrf, int dir)
{
int er,v;
//handle, request type, request, value, index, data, length, timeout
// 0B = set bitmode  0000 = mode<<8 | direction (reset = 00)
er=libusb_control_transfer(handle, 0x40, 0x0B, 0x0000, 0x01, NULL, 0, 5000);
//handle, request type, request, value, index, data, length, timeout
// 0B = set bitmode  4000 = mode<<8 | direction (async bitbang = 01)
v=0x0100+dir;
er=libusb_control_transfer(handle, 0x40, 0x0B, v, intrf, NULL, 0, 5000);
if (er) perror("set bitmode");
return 0;
}

//-------------------------------------------------------
//this one just prints out a text describing an error
//upon interface claim
void claim_error(int er)
{
printf("\nClaim interface error:  ");
switch (er)
    {
    case LIBUSB_ERROR_NOT_FOUND:
	{
	printf("requested interface does not exist\n");
	break;
	}
    case LIBUSB_ERROR_BUSY:
	{
	printf("another program has claimed this interface\n");
	break;
	}
    case LIBUSB_ERROR_NO_DEVICE:
	{
	printf("device not connected\n");
	break;
	}
    default:
	printf("Unknown error\n");
    }
}

//-------------------------------------------------------
//this one just prints out a text describing an error
//upon setting alt interface
void set_alt_error(int er)
{
printf("\nSet alt setting error:  ");
switch (er)
    {
    case LIBUSB_ERROR_NOT_FOUND:
	{
	printf("interface not found or wasn't claimed\n");
	break;
	}
    case LIBUSB_ERROR_NO_DEVICE:
	{
	printf("device not connected\n");
	break;
	}
    default:
	printf("Unknown error\n");
    }
}

//-------------------------------------------------------
//this one just prints out a text describing an transfer error
//called from callback in case of transfer error
void transfer_error(struct libusb_transfer *trans)
{
printf("\nAsync transfer error:  ");
switch (trans->status)
    {
    case LIBUSB_TRANSFER_ERROR:
	{
	printf("General error\n");
	break;
	}
    case LIBUSB_TRANSFER_TIMED_OUT:
	{
	printf("Timeout occured\n");
	break;
	}
    case LIBUSB_TRANSFER_CANCELLED:
	{
	printf("Transfer canceled\n");
	break;
	}
    case LIBUSB_TRANSFER_STALL:
	{
	printf("Stalled\n");
	break;
	}
    case LIBUSB_TRANSFER_OVERFLOW:
	{
	printf("Overflow\n");
	break;
	}
    case LIBUSB_TRANSFER_NO_DEVICE:
	{
	printf("No device\n");
	break;
	}
    default:
	printf("Unknown error\n");
    }
}



