//fftstuff.c		za direktno includanje

//	MC jun 2014

//pred tem mora biti includan <math.h> in <complex.h>


//--------------------------------------------------------------
//INTEGER
void fft(int n, int xr[], int xi[], int wr[], int wi[], int bi[])
{
int b,dp,a,t,p;
long xwr,xwi;

for (b=0;b<n;b++)
  if (bi[b]>b)
	{xwr=xr[b];xwi=xi[b];
	xr[b]=xr[bi[b]];xi[b]=xi[bi[b]];
	xr[bi[b]]=xwr;xi[bi[b]]=xwi;}

b=1;dp=n>>1;
do
  {a=0;
  do
	{t=a+b;p=0;
	do
	  {xwr=(long)xr[a+b]*wr[p]/65536-(long)xi[a+b]*wi[p]/65536;
	  xwi=(long)xr[a+b]*wi[p]/65536+(long)xi[a+b]*wr[p]/65536;
	  xr[a+b]=xr[a]/2-xwr;xi[a+b]=xi[a]/2-xwi;
	  xr[a]=xr[a]/2+xwr;xi[a]=xi[a]/2+xwi;
	  p=p+dp;a=a+1;}
	while (a<t);
	a=a+b;}
  while (a<n);
  dp=dp>>1;b=b<<1;}
while (b<n);
}


//--------------------------------------------------------------------
//INTEGER
void fftmojprip(int n,int wr[], int wi[], int bi[])
{
int k,l,m;
m=(int)(log((float)n)/log(1.9999999999999));
for (l=0;l<n;l++)    //bit reverse adrese
  {
  bi[l]=0;
  for (k=0;k<m;k++)
    bi[l]+=((l>>k)%2<<(m-k-1));
  }

for (l=0;l<n;l++)    //sin/cos tabela
  {wr[l]=32767*cos((float)l/(float)n*2.0*M_PI);
  wi[l]=-32767*sin((float)l/(float)n*2.0*M_PI);}
}

//---------------------------------------------------------
//FLOAT
// izracuna kompleksen FFT,  gain=velikost n  (za simusoido amplitude 1 bo izhod n)
//float verzija
void fft_f(unsigned int n, float xr[], float xi[], float wr[], float wi[], unsigned int bi[])
{
unsigned int b,dp,a,t,p;
float xwr,xwi;

for (b=0;b<n;b++)
  if (bi[b]>b)
	{xwr=xr[b];xwi=xi[b];
	xr[b]=xr[bi[b]];xi[b]=xi[bi[b]];
	xr[bi[b]]=xwr;xi[bi[b]]=xwi;}

b=1;dp=n>>1;
do
  {a=0;
   do
	{t=a+b;p=0;
	do
	  {xwr=xr[a+b]*wr[p]-xi[a+b]*wi[p];
	  xwi=xr[a+b]*wi[p]+xi[a+b]*wr[p];
	  xr[a+b]=xr[a]-xwr;xi[a+b]=xi[a]-xwi;
	  xr[a]=xr[a]+xwr;xi[a]=xi[a]+xwi;
	  p=p+dp;a++;}
	while (a<t);
	a=a+b;}
  while (a<n);
  dp=dp>>1;b=b<<1;}
while (b<n);
}


//------------------------------------------------------
//FLOAT
//pripravi tabele za FFT   (sin/cos in bitreverse)
void fftmojprip_f(unsigned int n, float wr[], float wi[], unsigned int bi[])
{
unsigned int k,l,m;
m=(int)(log((double)n)/log(1.9999999999999));
for (l=0;l<n;l++)    //bit reverse adrese
  {
  bi[l]=0;
  for (k=0;k<m;k++)
    bi[l]+=((l>>k)%2<<(m-k-1));
  }

for (l=0;l<n;l++)    //sin/cos tabela
  {wr[l]=cos((float)l/(float)n*2.0*M_PI);
  wi[l]=-sin((float)l/(float)n*2.0*M_PI);}
}
/*
//---------------------------------------------------------
//COMPLEX FLOAT
// izracuna kompleksen FFT,  gain=velikost n  (za simusoido amplitude 1 bo izhod n)
//float verzija
void fft_c(unsigned int n, complex float x[], complex float w[], unsigned int bi[])
{
unsigned int b,dp,a,t,p;
complex float xw;

for (b=0;b<n;b++)
  if (bi[b]>b)
    { xw=x[b]; x[b]=x[bi[b]]; x[bi[b]]=xw; }

b=1;dp=n>>1;
do
  {a=0;
    do
      {t=a+b;p=0;
	do
	  { xw=x[a+b]*w[p]; x[a+b]=x[a]-xw; x[a]=x[a]+xw; p=p+dp;a++; }
	while (a<t);
	a=a+b;}
    while (a<n);
  dp=dp>>1;b=b<<1;}
while (b<n);
}


//------------------------------------------------------
//COMPLEX FLOAT
//pripravi tabele za FFT   (sin/cos in bitreverse)
void fftmojprip_c(unsigned int n, complex float w[], unsigned int bi[])
{
unsigned int k,l,m;
m=(int)(log((double)n)/log(1.9999999999999));
for (l=0;l<n;l++)    //bit reverse adrese
  {
  bi[l]=0;
  for (k=0;k<m;k++)
    bi[l]+=((l>>k)%2<<(m-k-1));
  }

for (l=0;l<n;l++)    //sin/cos tabela
  {w[l]=cos((float)l/(float)n*2.0*M_PI)-I*sin((float)l/(float)n*2.0*M_PI);}
}

*/

//------------------------------------------------------------
//   pripravi window za FFT
void pripwin(int m, float wind[], int tip, float wf)
{
int i,n;
double g;
n=m;		//m-1??
g=0.0;
for (i=0;i<n;i++)
	{
	switch (tip)
		{
		case 0:		//pravokotno
			{
			wind[i]=1.0;
			g=g+wind[i];
			break;
			}
		case 1:		//hamming
			{
			wind[i]=0.54-0.46*cos((float)i/(float)n*2.0*M_PI);
			g=g+wind[i];
			break;
			}
		case 2:		//hann raised cos
			{
			wind[i]=0.5-0.5*cos((float)i/(float)n*2.0*M_PI);
			g=g+wind[i];
			break;
			}
		case 3:		//Blackman
			{
			wind[i]=0.42323-0.49755*cosf((float)i/(float)n*2.0*M_PI);
			wind[i]=wind[i]+0.07922*cosf((float)i/(float)n*4.0*M_PI);
			g=g+wind[i];
			break;
			}
		case 4:		//Blackman-Harris
			{
			wind[i]=0.35875-0.48829*cosf((float)i/(float)n*2.0*M_PI);
			wind[i]=wind[i]+0.14128*cosf((float)i/(float)n*4.0*M_PI);
			wind[i]=wind[i]-0.01168*cosf((float)i/(float)n*6.0*M_PI);
			g=g+wind[i];
			break;
			}
		default:
			break;
		}
	}

g=g/(double)n;
for (i=0;i<n;i++)
	{
	wind[i]=wf*wind[i]/g;
	}

switch (tip)
	{
	case 0:
//		printf("Rect, wf=%f\n",wf/g);
//		*wf=1.0;
		break;
	case 1:
//		printf("Hamm, wf=%f\n",wf/g);
//		*wf=0.54;
		break;
	case 2:
//		printf("Hann, wf=%f\n",wf/g);
//		*wf=0.5;
		break;
	case 3:
//		printf("Blck, wf=%f\n",wf/g);
//		*wf=0.423;
		break;
	case 4:
//		*wf=0.3587;
//		printf("BlHr, wf=%f\n",wf/g);
		break;
	default:
		printf("Neznano okno %d",tip);
		break;
	}

}

