// Xgraf.c	funkcije za X risanje
//		kar za direktno includanje...

//		MC okt 2008

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

#include <math.h>
#include <stdlib.h>
//stdlib za exit()
 
Display *dis;				//globalne spremenljivke za X risanje
int screen;
Window win;
GC gc,gc2;
Colormap cmap;
unsigned int barva[16];
//----------------------------------------------------------
void init_x(int vx, int vy, char *ime1, char *ime2)
{

	XEvent ev;

        unsigned long black,white;
        dis=XOpenDisplay((char *)0);
        screen=DefaultScreen(dis);
        black=BlackPixel(dis,screen);   /* get color black */
        white=WhitePixel(dis,screen);  /* get color white */

        win=XCreateSimpleWindow(dis,DefaultRootWindow(dis),20,30,
                vx, vy, 5, white, black);

        XSetStandardProperties(dis,win,ime1,ime2,None,NULL,0,NULL);

        XSelectInput(dis, win, ExposureMask|ButtonPressMask|KeyPressMask|StructureNotifyMask);

        gc=XCreateGC(dis, win, 0,0);
        gc2=XCreateGC(dis, win, 0,0);

	//gc2 za debelejse crte
	XSetLineAttributes(dis,gc2,2,LineSolid,CapButt,JoinMiter);

        XSetBackground(dis,gc,black);
        XSetForeground(dis,gc,white);

        XSetBackground(dis,gc2,black);
        XSetForeground(dis,gc2,white);

        XClearWindow(dis, win);
        XMapRaised(dis, win);
//	XMapWindow(dis,win);

	do
		{
		XNextEvent(dis, &ev);
		}
	while (ev.type != MapNotify);

	XFlush(dis);
};
//------------------------------------------------------------
void close_x()
{
//	XFreeColormap(dis,cmap);
	XFreeGC(dis, gc);
	XFreeGC(dis, gc2);
        XDestroyWindow(dis,win);
        XCloseDisplay(dis);
        exit(1);
}
//----------------------------------------------------------
//paleta za false color display	  tip 1  (okrogle vrednosti)
void barva_palete(int n, float *r, float *g, float *b)
{
switch (n)
	{
	case 0:{*r=0.0; *g=0.0; *b=0.0;break;}	//black
	case 1:{*r=0.0; *g=0.0; *b=0.25;break;}	//very dark blue
	case 2:{*r=0.0; *g=0.0; *b=0.5;break;}	//dark blue
	case 3:{*r=0.0; *g=0.0; *b=0.75;break;}	//blue
	case 4:{*r=0.0; *g=0.0; *b=1.0;break;}	//light blue
	case 5:{*r=0.0; *g=0.25;*b=1.0;break;}	//very light blue
	case 6:{*r=0.0; *g=0.5; *b=0.5;break;}	//greenish blue
	case 7:{*r=0.0; *g=0.75;*b=0.25;break;}	//dark green
	case 8:{*r=0.0; *g=1.0; *b=0.0;break;}	//light green
	case 9:{*r=0.75;*g=1.0; *b=0.0;break;}	//yellowish green
	case 10:{*r=1.0; *g=1.0; *b=0.0;break;}	//yellow
	case 11:{*r=1.0; *g=0.5; *b=0.0;break;}	//orange
	case 12:{*r=1.0; *g=0.0; *b=0.0;break;}	//red
	case 13:{*r=1.0; *g=0.25;*b=0.5;break;}	//pink
	case 14:{*r=1.0; *g=0.5; *b=0.75;break;}//light pink
	case 15:{*r=1.0; *g=1.0; *b=1.0;break;}	//white
	default: printf("\nOnly 16 colors in palette!! n=%d\n",n);
	}
}

//----------------------------------------------------------
//paleta za false color display	  po IRIS meteo radarju 16 level
void meteo_paleta16(int n, float *r, float *g, float *b)
{
switch (n)
	{
	case 0:{*r=0.0; *g=0.0; *b=0.0;break;}	//black
	case 1:{*r=0.21; *g=0.43; *b=0.98;break;}
	case 2:{*r=0.21; *g=0.6; *b=0.99;break;}
	case 3:{*r=0.22; *g=0.76; *b=0.96;break;}
	case 4:{*r=0.2; *g=0.9; *b=1.0;break;}
	case 5:{*r=0.19; *g=0.84;*b=0.55;break;}
	case 6:{*r=0.2; *g=0.93; *b=0.17;break;}
	case 7:{*r=0.55; *g=0.99;*b=0.21;break;}
	case 8:{*r=0.78; *g=0.99; *b=0.2;break;}
	case 9:{*r=0.97;*g=0.98; *b=0.23;break;}
	case 10:{*r=1.0; *g=0.8; *b=0.21;break;}
	case 11:{*r=0.96; *g=0.64; *b=0.22;break;}
	case 12:{*r=1.0; *g=0.39; *b=0.24;break;}
	case 13:{*r=0.85; *g=0.17;*b=0.18;break;}
	case 14:{*r=0.68; *g=0.16; *b=0.16;break;}
	case 15:{*r=0.84; *g=0.15; *b=0.79;break;}
	default: printf("\nOnly 16 colors in palette!! n=%d\n",n);
	}
}

//------------------------------------------
//pretvorba v int barvo za VGA kartice itd
void int_barva(int bitov, float r, float g, float b, unsigned int *barva)
{
switch (bitov)
	{
	case 16:
		{
//		*barva=2048*floorf(r*31.0);
//		*barva=*barva+32*floorf(g*63.0);
//		*barva=*barva+floorf(b*31.0);
		*barva=2048*rintf(r*31.0);
		*barva=*barva+32*rintf(g*63.0);
		*barva=*barva+rintf(b*31.0);
		break;
		}
	case 24:
		{
//		*barva=65536*floorf(r*255.0);
//		*barva=*barva+256*floorf(g*255.0);
//		*barva=*barva+floorf(b*255.0);
		*barva=65536*rintf(r*255.0);
		*barva=*barva+256*rintf(g*255.0);
		*barva=*barva+rintf(b*255.0);
		break;
		}
	default: printf("\nunknown bit depth %d",bitov); 
	}
}

//-----------------------------------------
//make a color palette for Xlib
void setpal16(unsigned int barva[])
{
int i,bpp;
float r,g,b;	//vrednosti 0...1

bpp=DefaultDepth(dis,screen);
for (i=0;i<16;i++)
	{
	barva_palete(i,&r,&g,&b);
	int_barva(bpp,r,g,b,&barva[i]);
	}
}

//-----------------------------------------
// siva barva
unsigned int siva(float sivina)
{
unsigned int bb;

int_barva(DefaultDepth(dis,screen),sivina,sivina,sivina,&bb);
return bb;
}

//---------------------------------------------------------
//narise markercek
void marker(int x, int y, int vel, int luknja)
{
XDrawLine(dis,win,gc,x-vel,y,x-luknja,y);
XDrawLine(dis,win,gc,x+luknja,y,x+vel,y);
XDrawLine(dis,win,gc,x,y-vel,x,y-luknja);
XDrawLine(dis,win,gc,x,y+luknja,x,y+vel);
}

//-----------------------------------------------------
//narisce puscico
void puscica(int x0, int y0, float kot, float vel)
{
int xz,yz,xk,yk;

xz=x0-(int)(vel/2.0*cosf(kot));
yz=y0-(int)(vel/2.0*sinf(kot));
xk=x0+(int)(vel/2.0*cosf(kot));
yk=y0+(int)(vel/2.0*sinf(kot));
XDrawLine(dis,win,gc2,xz,yz,xk,yk);
xz=x0+(int)(vel/2.0*cosf(kot));
yz=y0+(int)(vel/2.0*sinf(kot));
xk=x0+(int)(vel/2.0*cosf(kot)-vel/3.0*cosf(kot+3.14159265358979/10.0));
yk=y0+(int)(vel/2.0*sinf(kot)-vel/3.0*sinf(kot+3.14159265358979/10.0));
XDrawLine(dis,win,gc2,xz,yz,xk,yk);
xz=x0+(int)(vel/2.0*cosf(kot));
yz=y0+(int)(vel/2.0*sinf(kot));
xk=x0+(int)(vel/2.0*cosf(kot)-vel/3.0*cosf(kot-3.14159265358979/10.0));
yk=y0+(int)(vel/2.0*sinf(kot)-vel/3.0*sinf(kot-3.14159265358979/10.0));
XDrawLine(dis,win,gc2,xz,yz,xk,yk);
}

//--------------------------------------------------
//narise zvezdo
//deb = 0...1 "debelina", 1.0 => mnogokotnik  0=samo sprikle
// ,,,0.15,3 = mercedes   ,,,0.25,4 = NATO, ,,,0.4,5 = petokraka
// ,,,0.57,6 = zidovska
void zvezda(int x0, int y0, float vel, float deb, int krakov)
{
int i;
int x1,x2,x3,y1,y2,y3;
float k,kk;

kk=2.0*3.14159265358979/(float)krakov;
for (i=0;i<krakov;i++)
	{
	k=(float)i*kk+3.14159265358979/2.0;
	x1=x0+(int)(deb*vel*cosf(k-kk/2.0));
	y1=y0-(int)(deb*vel*sinf(k-kk/2.0));
	x2=x0+(int)(vel*cosf(k));
	y2=y0-(int)(vel*sinf(k));
	x3=x0+(int)(deb*vel*cosf(k+kk/2.0));
	y3=y0-(int)(deb*vel*sinf(k+kk/2.0));
//printf("%f %d %d %d %d %d %d\n",k,x1,y1,x2,y2,x3,y3);
	XDrawLine(dis,win,gc,x1,y1,x2,y2);
	XDrawLine(dis,win,gc,x2,y2,x3,y3);
	}

}

//---------------------------------------------------------
//narise preprost graf integer arraya
void graf_i(int minx, int maxx, int miny, int maxy, int *data)
{
int xp,yp;	//polozaj (zgornji levi vogal)
int xv,yv;	//velikost
int x,y,xs,ys,i;

xp=20;yp=20;
xv=512;yv=256;

XSetForeground(dis,gc,barva[10]);

//okvir
XDrawLine(dis,win,gc,xp,yp,xp+xv,yp);
XDrawLine(dis,win,gc,xp+xv,yp,xp+xv,yp+yv);
XDrawLine(dis,win,gc,xp+xv,yp+yv,xp,yp+yv);
XDrawLine(dis,win,gc,xp,yp+yv,xp,yp);
//kriz preko sredine
XSetForeground(dis,gc,barva[6]);
XDrawLine(dis,win,gc,xp+xv/2,yp,xp+xv/2,yp+yv);
XDrawLine(dis,win,gc,xp,yp+yv/2,xp+xv,yp+yv/2);


if ((miny*maxy)<0)	//crta pri y=0
	{
	y=yp+yv-yv*(float)(0-miny)/(float)(maxy-miny);
	XDrawLine(dis,win,gc,xp,y,xp+xv,y);
	}

XSetForeground(dis,gc,barva[15]);
xs=xp;
ys=yp+yv-yv*(float)(data[minx]-miny)/(float)(maxy-miny);
for (i=minx+1;i<maxx;i++)
	{
	x=xp+xv*(float)(i-minx)/(float)(maxx-minx);
	y=yp+yv-yv*(float)(data[i]-miny)/(float)(maxy-miny);
	XDrawLine(dis,win,gc,xs,ys,x,y);
	xs=x; ys=y;
	}

}

//---------------------------------------------------------
//narise preprost graf float arraya
//od indeksa xmin do indeksa xmax
//xp,yp,xv,yv = polozaj in velikost
void graf_f(int minx, int maxx, float miny, float maxy, float *data, int xp, int yp, int xv, int yv)
{
int x,y,xs,ys,i;

/*
XSetForeground(dis,gc,barva[10]);

//okvir
XDrawLine(dis,win,gc,xp,yp,xp+xv,yp);
XDrawLine(dis,win,gc,xp+xv,yp,xp+xv,yp+yv);
XDrawLine(dis,win,gc,xp+xv,yp+yv,xp,yp+yv);
XDrawLine(dis,win,gc,xp,yp+yv,xp,yp);
//kriz preko sredine
XSetForeground(dis,gc,barva[6]);
XDrawLine(dis,win,gc,xp+xv/2,yp,xp+xv/2,yp+yv);
XDrawLine(dis,win,gc,xp,yp+yv/2,xp+xv,yp+yv/2);


if ((miny*maxy)<0)	//crta pri y=0
	{
	y=yp+yv-yv*(0.0-miny)/(maxy-miny);
	XDrawLine(dis,win,gc,xp,y,xp+xv,y);
	}
*/
XSetForeground(dis,gc,barva[15]);
xs=xp;
ys=yp+yv-yv*(data[minx]-miny)/(maxy-miny);
if (ys>yp+yv) ys=yp+yv;  if (ys<yp) ys=yp;
for (i=minx+1;i<maxx;i++)
	{
	x=xp+xv*(float)(i-minx)/(float)(maxx-minx);
	y=yp+yv-yv*(data[i]-miny)/(maxy-miny);
	if (y>yp+yv) y=yp+yv;  if (y<yp) y=yp;
	XDrawLine(dis,win,gc,xs,ys,x,y);
	xs=x; ys=y;
	}
}

//-----------------------------------------------------
void mreza(int nx, int ny, int xp, int yp, int xv, int yv)
{
int i,x,y;

for (i=0;i<=nx;i++)
  {
  x=xp+i*((float)xv/(float)nx);
  XDrawLine(dis,win,gc,x,yp,x,yp+yv);
  }
for (i=0;i<=ny;i++)
  {
  y=yp+i*((float)yv/(float)ny);
  XDrawLine(dis,win,gc,xp,y,xp+xv,y);
  }
}

//-----------------------------------------------------
void mreza_logy(int nx, float miny, float maxy, int xp, int yp, int xv, int yv)
{
int i,x,y,mind,maxd;
float dek;	//koliko pixlov je dekada
float xm;

for (i=0;i<=nx;i++)
  {
  x=xp+i*((float)xv/(float)nx);
  XDrawLine(dis,win,gc,x,yp,x,yp+yv);
  }

mind=(int)log10f(miny); maxd=(int)log10(maxy);
dek=yv/log10(maxy/miny);
xm=powf(10.0,(log10f(miny)-mind+1.0));
//spodnji del
for (x=xm;x<=10;x++)
  {
  y=yp+yv-dek*((mind-1-log10f(miny))+log10f((float)x));
  if (y<=yp+yv)
    XDrawLine(dis,win,gc,xp,y,xp+xv,y);
  }
//cele dekade
for (i=mind;i<maxd;i++)
  {
  for (x=2;x<=10;x++)
    {
    y=yp+yv-dek*((i-log10f(miny))+log10f((float)x));
    XDrawLine(dis,win,gc,xp,y,xp+xv,y);
    }
  }
xm=powf(10.0,(log10f(maxy)-maxd));
//zgornji del
for (x=2;x<=xm+1;x++)
  {
  y=yp+yv-dek*((maxd-log10f(miny))+log10f((float)x));
  if (y>=yp)
    XDrawLine(dis,win,gc,xp,y,xp+xv,y);
  }
}

//--------------------------------------------------------
//xz,xk,y [pixels]
void skala_x(int xz, int xk, int y, float vxz, float vxk, int nx, char *format, float modulo)
{
int i,x,sl;
float v;
char string[256];

for (i=0;i<=nx;i++)
  {
  x=xz+i*(xk-xz)/nx;
  v=vxz+i*(vxk-vxz)/(float)nx;
  if (modulo != 0.0) while (v>=modulo) v-=modulo;
  sprintf(string,format,v); sl=strlen(string);
  XDrawString(dis,win,gc,x-3*sl,y+14,string,strlen(string));
  }

}




