`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date:    08:38:31 09/30/2019 
// Design Name: 
// Module Name:    packer2 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: 
//
//  v dolzini "LEN" so upostevani tudi trije metapodatki
//	 celoten paket ima LEN+2 worda, +2 = header, len
//
//////////////////////////////////////////////////////////////////////////////////
module packer2x8(
    input clk,
    input rst,
    input [15:0] indata1,
    input [15:0] indata2,
    input [15:0] indata3,
    input [15:0] indata4,
    input [15:0] indata5,
    input [15:0] indata6,
    input [15:0] indata7,
    input [15:0] indata8,
    input in_data_av,
    input [15:0] len,
    input [3:0] pktyp,
    input [15:0] meta1,
    input [15:0] meta2,
	 output rd_en,
    output [15:0] outdata,
    output out_data_av
    );

localparam STATE_SIZE=4;

localparam	IDLE=0,
				DATA1=1,
				DATA2=2,
				DATA3=3,
				DATA4=4,
				DATA5=5,
				DATA6=6,
				DATA7=7,
				DATA8=8,
				HEAD=9,
				LEN=10,
				META1=11,
				META2=12,
				META3=13;
				
reg [STATE_SIZE-1 : 0]state_q = 4'b0;
reg [15 : 0] count_q;
reg [11 : 0] pkcount_q;
reg [15 : 0] outdata_r;
reg out_data_av_r;
reg rd_en_r;
reg [15 : 0] data2,data3,data4,data5,data6,data7,data8;

assign outdata = outdata_r;
assign out_data_av = out_data_av_r;
assign rd_en = rd_en_r;

always @(posedge clk)
	begin
	if (rst)
		begin
		state_q <= IDLE;
		count_q <= 16'h0000;
		end
	else
		begin
		case (state_q)
			IDLE:
				begin
				if (in_data_av)
					begin
					outdata_r <= indata1;
					data2 <= indata2;
					data3 <= indata3;
					data4 <= indata4;
					data5 <= indata5;
					data6 <= indata6;
					data7 <= indata7;
					data8 <= indata8;
					rd_en_r <= 1'b1;
					out_data_av_r <= 1'b0;
					state_q <= DATA1;
					end
				else
					begin
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b0;
					state_q <= IDLE;
					end
				end
			DATA1:
				begin
				if (count_q == 16'b0)
					begin
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;	//za header
					outdata_r <= 16'hAA55;
					state_q <= HEAD;
					end
				else
					begin
					count_q <= count_q - 1;
					outdata_r <= data2;
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;
					state_q <= DATA2;
//					state_q <= IDLE;
					end
				end
			DATA2:
				begin
				if (count_q == 16'b0)
					begin
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;	//za header
					outdata_r <= 16'hAA55;
					state_q <= HEAD;
					end
				else
					begin
					count_q <= count_q - 1;
					outdata_r <= data3;
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;
//					state_q <= DATA;
					state_q <= DATA3;
					end
				end
			DATA3:
				begin
				if (count_q == 16'b0)
					begin
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;	//za header
					outdata_r <= 16'hAA55;
					state_q <= HEAD;
					end
				else
					begin
					count_q <= count_q - 1;
					outdata_r <= data4;
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;
//					state_q <= DATA;
					state_q <= DATA4;
					end
				end
			DATA4:
				begin
				if (count_q == 16'b0)
					begin
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;	//za header
					outdata_r <= 16'hAA55;
					state_q <= HEAD;
					end
				else
					begin
					count_q <= count_q - 1;
					outdata_r <= data5;
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;
//					state_q <= DATA;
					state_q <= DATA5;
					end
				end
			DATA5:
				begin
				if (count_q == 16'b0)
					begin
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;	//za header
					outdata_r <= 16'hAA55;
					state_q <= HEAD;
					end
				else
					begin
					count_q <= count_q - 1;
					outdata_r <= data6;
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;
					state_q <= DATA6;
//					state_q <= IDLE;
					end
				end
			DATA6:
				begin
				if (count_q == 16'b0)
					begin
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;	//za header
					outdata_r <= 16'hAA55;
					state_q <= HEAD;
					end
				else
					begin
					count_q <= count_q - 1;
					outdata_r <= data7;
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;
//					state_q <= DATA;
					state_q <= DATA7;
					end
				end
			DATA7:
				begin
				if (count_q == 16'b0)
					begin
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;	//za header
					outdata_r <= 16'hAA55;
					state_q <= HEAD;
					end
				else
					begin
					count_q <= count_q - 1;
					outdata_r <= data8;
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;
//					state_q <= DATA;
					state_q <= DATA8;
					end
				end
			DATA8:
				begin
				if (count_q == 16'b0)
					begin
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;	//za header
					outdata_r <= 16'hAA55;
					state_q <= HEAD;
					end
				else
					begin
					count_q <= count_q - 1;
					outdata_r <= data8;
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;
//					state_q <= DATA;
					state_q <= IDLE;
					end
				end
			HEAD:
				begin
				outdata_r <= len;
				count_q <= len - 1;
//				count_q <= len;
				state_q <= LEN;
				pkcount_q <= pkcount_q + 1;
				end
			LEN:
				begin
				count_q <= count_q - 1;
				outdata_r <= {pktyp,pkcount_q};
				state_q <= META1;
				end
			META1:
				begin
				count_q <= count_q - 1;
				outdata_r <= meta1;
				state_q <= META2;
				end
			META2:
				begin
				count_q <= count_q - 1;
				outdata_r <= meta2;
				state_q <= META3;
				end
			META3:
				begin
/*				if (in_data_av)
					begin
					count_q <= count_q - 1;
					outdata_r <= indata;
					rd_en_r <= 1'b1;
					out_data_av_r <= 1'b1;	//za meta3
					state_q <= DATA;
					end
				else
*/					begin
					rd_en_r <= 1'b0;
					out_data_av_r <= 1'b1;	//za meta3
					state_q <= IDLE;
					end
				end
			default:
				begin
				rd_en_r <= 1'b0;
				out_data_av_r <= 1'b0;
				state_q <= IDLE;
				count_q <= len;
				end
		endcase
		end
	end

endmodule
